/*      Renegade Scripts.dll
        Example Plugin Code
        Copyright 2007 Whitedragon(MDB), Jonathan Wilson
 
        This file is part of the Renegade scripts.dll
        The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
        the terms of the GNU General Public License as published by the Free
        Software Foundation; either version 2, or (at your option) any later
        version. See the file COPYING for more details.
        In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
        Only the source code to the module(s) containing the licenced code has to be released.
*/
 
/*  This is designed to serve as both an example on how to make a plugin and to give users the basic framework of a plugin.
    The plugin is simple: it creates an object creation hook and attaches the script "Plugin_Example_Script" to all objects.
        The script prints out a message whenever an object is created or destroyed.
        There are also examples of the new format for bhs.dll hooks.
*/
 
#include "scripts.h"
#include <stdarg.h>
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "engine.h"
#include "gmmain.h"
#include "radiocommands.h"
#include <time.h>

int LastPress[128];
int TauntPressWaitTime = 0;
bool PrefixRadio = false;

_AddRadioHook AddRadioHook = 0;

SimpleDynVecClass<RadioCommand *> Ctrl_1_GDI, Ctrl_2_GDI, Ctrl_3_GDI, Ctrl_4_GDI, Ctrl_5_GDI;
SimpleDynVecClass<RadioCommand *> Ctrl_6_GDI, Ctrl_7_GDI, Ctrl_8_GDI, Ctrl_9_GDI, Ctrl_0_GDI;
SimpleDynVecClass<RadioCommand *> Ctrl_1_Nod, Ctrl_2_Nod, Ctrl_3_Nod, Ctrl_4_Nod, Ctrl_5_Nod;
SimpleDynVecClass<RadioCommand *> Ctrl_6_Nod, Ctrl_7_Nod, Ctrl_8_Nod, Ctrl_9_Nod, Ctrl_0_Nod;

SimpleDynVecClass<RadioCommand *> Alt_1_GDI, Alt_2_GDI, Alt_3_GDI, Alt_4_GDI, Alt_5_GDI;
SimpleDynVecClass<RadioCommand *> Alt_6_GDI, Alt_7_GDI, Alt_8_GDI, Alt_9_GDI, Alt_0_GDI;
SimpleDynVecClass<RadioCommand *> Alt_1_Nod, Alt_2_Nod, Alt_3_Nod, Alt_4_Nod, Alt_5_Nod;
SimpleDynVecClass<RadioCommand *> Alt_6_Nod, Alt_7_Nod, Alt_8_Nod, Alt_9_Nod, Alt_0_Nod;

SimpleDynVecClass<RadioCommand *> CtrlAlt_1_GDI, CtrlAlt_2_GDI, CtrlAlt_3_GDI, CtrlAlt_4_GDI, CtrlAlt_5_GDI;
SimpleDynVecClass<RadioCommand *> CtrlAlt_6_GDI, CtrlAlt_7_GDI, CtrlAlt_8_GDI, CtrlAlt_9_GDI, CtrlAlt_0_GDI;
SimpleDynVecClass<RadioCommand *> CtrlAlt_1_Nod, CtrlAlt_2_Nod, CtrlAlt_3_Nod, CtrlAlt_4_Nod, CtrlAlt_5_Nod;
SimpleDynVecClass<RadioCommand *> CtrlAlt_6_Nod, CtrlAlt_7_Nod, CtrlAlt_8_Nod, CtrlAlt_9_Nod, CtrlAlt_0_Nod;

SimpleDynVecClass<RadioCommand *> Taunt1_GDI, Taunt2_GDI, Taunt3_GDI, Taunt4_GDI, Taunt5_GDI;
SimpleDynVecClass<RadioCommand *> Taunt6_GDI, Taunt7_GDI, Taunt8_GDI, Taunt9_GDI;
 
SimpleDynVecClass<RadioCommand *> Taunt1_Nod, Taunt2_Nod, Taunt3_Nod, Taunt4_Nod, Taunt5_Nod;
SimpleDynVecClass<RadioCommand *> Taunt6_Nod, Taunt7_Nod, Taunt8_Nod, Taunt9_Nod;

void Load_Radio_Command(char *Section, SimpleDynVecClass<RadioCommand *>& Vec)
{
	INIClass *ini = Get_INI("../custom_radio_commands.ini");
	if(!ini)
	{
		Console_Output("Plugin Sounds Error: custom_radio_commands.ini not found in the main FDS folder.\n");
	}
	else
	{
		char entry[128];
		char buffer[256], buffer2[256], buffer3[256];
		for(int i = 1; i < 256; i++)
		{
			sprintf(entry, "%.2d_Text", i);
			ini->Get_String(Section, entry, "", buffer, 256);
			sprintf(entry, "%.2d_Sound", i);
			ini->Get_String(Section, entry, "", buffer2, 256);
			sprintf(entry, "%.2d_Icon", i);
			ini->Get_String(Section, entry, "", buffer3, 256);
			
			if(*entry != 0)
			{
				RadioCommand *r = new RadioCommand;
				if(sscanf(buffer, "%s", r->Text) < 1)
				{
					break;					
				}
				if(sscanf(buffer2, "%s", r->Sound) < 1)
				{
					break;
				}
				if(sscanf(buffer3, "%s", r->Icon) < 1)
				{
					break;
				}
				strcpy(r->Text, buffer);
				strcpy(r->Sound, buffer2);
				strcpy(r->Icon, buffer3);
				Vec.Add(r);					
				continue;
			}
			break;
		}
    Release_INI(ini);
	}
} 

inline void LoadHook(HMODULE dll, void **hook, const char *name)
{
	*hook = (void *)GetProcAddress(dll, name);
	if(!*hook)
	{
		printf("Error loading \"%s\"", name);
		*hook = 0;
	}
}

void Plugin_Load() 
{
	INIClass *ini = Get_INI("../custom_radio_commands.ini");
	bool EnableStockRadioCommands = ini->Get_Bool("General", "EnableStockRadioCommands", false);
	bool EnableTauntRadioCommands = ini->Get_Bool("General", "EnableTauntRadioCommands", false);
	PrefixRadio = ini->Get_Bool("General", "PrefixRadio", false);
	TauntPressWaitTime = ini->Get_Int("General", "TauntPressWaitTime", false);
	Release_INI(ini);

	if (EnableStockRadioCommands)
	{
		Load_Radio_Commands();
		HMODULE hooks = LoadLibrary("Hooks.dll");
		LoadHook(hooks, (void **)&AddRadioHook, "AddRadioHook");
		AddRadioHook(Radio_Hook);
	}

	if (EnableTauntRadioCommands)
	{
		new ScriptRegistrant<Iran_Radio_Taunt_Key>("MDB_SSGM_Taunt_Key", "Key:string,Anim:string");
		//ScriptRegistrant<Iran_Radio_Taunt_Key> MDB_SSGM_Taunt_Key_Registrant("MDB_SSGM_Taunt_Key","Key:string,Anim:string");
		Load_Taunt_Radio_Commands();
	}
} 

void Play_Random_Radio_Command(SimpleDynVecClass<RadioCommand *>& Vec, int Team, int ID)
{
	char tmp[256];
	LARGE_INTEGER cicles;

	QueryPerformanceCounter(&cicles);
	srand (cicles.QuadPart);
	int i = rand() % Vec.Length();
	sprintf(tmp, "sndt %d %s", Team, Vec[i]->Sound);
	Console_Input(tmp);
	sprintf(tmp, "%s", PrefixRadio ? "[Radio] " : ""); // DEBUG CRAP need to add an option
	sprintf(tmp, "%s%s: %s", tmp, Get_Player_Name_By_ID(ID), Vec[i]->Text);
	unsigned int Red = 0,Blue = 0,Green = 0;
	Get_Team_Color(Team,&Red,&Green,&Blue);
	if (Team == 1)
		Send_Message_Team(1, Red, Green, Blue, tmp);
	else		  
		Send_Message_Team(0, Red, Green, Blue, tmp);
	sprintf(tmp, "icon %d %s", ID, Vec[i]->Icon);
	Console_Input(tmp);
}

bool Radio_Hook(int Team, int PlayerID, int a, int RadioID, int b)
{
	if (RadioID == 0) Play_Random_Radio_Command(Team ? Ctrl_1_GDI : Ctrl_1_Nod, Team, PlayerID);
	if (RadioID == 1) Play_Random_Radio_Command(Team ? Ctrl_2_GDI : Ctrl_2_Nod, Team, PlayerID);
	if (RadioID == 2) Play_Random_Radio_Command(Team ? Ctrl_3_GDI : Ctrl_3_Nod, Team, PlayerID);
	if (RadioID == 3) Play_Random_Radio_Command(Team ? Ctrl_4_GDI : Ctrl_4_Nod, Team, PlayerID);
	if (RadioID == 4) Play_Random_Radio_Command(Team ? Ctrl_5_GDI : Ctrl_5_Nod, Team, PlayerID);
	if (RadioID == 5) Play_Random_Radio_Command(Team ? Ctrl_6_GDI : Ctrl_6_Nod, Team, PlayerID);
	if (RadioID == 6) Play_Random_Radio_Command(Team ? Ctrl_7_GDI : Ctrl_7_Nod, Team, PlayerID);
	if (RadioID == 7) Play_Random_Radio_Command(Team ? Ctrl_8_GDI : Ctrl_8_Nod, Team, PlayerID);
	if (RadioID == 8) Play_Random_Radio_Command(Team ? Ctrl_9_GDI : Ctrl_9_Nod, Team, PlayerID);
	if (RadioID == 9) Play_Random_Radio_Command(Team ? Ctrl_0_GDI : Ctrl_0_Nod, Team, PlayerID);
	if (RadioID == 10) Play_Random_Radio_Command(Team ? Alt_1_GDI : Alt_1_Nod, Team, PlayerID);
	if (RadioID == 11) Play_Random_Radio_Command(Team ? Alt_2_GDI : Alt_2_Nod, Team, PlayerID);
	if (RadioID == 12) Play_Random_Radio_Command(Team ? Alt_3_GDI : Alt_3_Nod, Team, PlayerID);
	if (RadioID == 13) Play_Random_Radio_Command(Team ? Alt_4_GDI : Alt_4_Nod, Team, PlayerID);
	if (RadioID == 14) Play_Random_Radio_Command(Team ? Alt_5_GDI : Alt_5_Nod, Team, PlayerID);
	if (RadioID == 15) Play_Random_Radio_Command(Team ? Alt_6_GDI : Alt_6_Nod, Team, PlayerID);
	if (RadioID == 16) Play_Random_Radio_Command(Team ? Alt_7_GDI : Alt_7_Nod, Team, PlayerID);
	if (RadioID == 17) Play_Random_Radio_Command(Team ? Alt_8_GDI : Alt_8_Nod, Team, PlayerID);
	if (RadioID == 18) Play_Random_Radio_Command(Team ? Alt_9_GDI : Alt_9_Nod, Team, PlayerID);
	if (RadioID == 19) Play_Random_Radio_Command(Team ? Alt_0_GDI : Alt_0_Nod, Team, PlayerID);
	if (RadioID == 20) Play_Random_Radio_Command(Team ? CtrlAlt_1_GDI : CtrlAlt_1_Nod, Team, PlayerID);
	if (RadioID == 21) Play_Random_Radio_Command(Team ? CtrlAlt_2_GDI : CtrlAlt_2_Nod, Team, PlayerID);
	if (RadioID == 22) Play_Random_Radio_Command(Team ? CtrlAlt_3_GDI : CtrlAlt_3_Nod, Team, PlayerID);
	if (RadioID == 23) Play_Random_Radio_Command(Team ? CtrlAlt_4_GDI : CtrlAlt_4_Nod, Team, PlayerID);
	if (RadioID == 24) Play_Random_Radio_Command(Team ? CtrlAlt_5_GDI : CtrlAlt_5_Nod, Team, PlayerID);
	if (RadioID == 25) Play_Random_Radio_Command(Team ? CtrlAlt_6_GDI : CtrlAlt_6_Nod, Team, PlayerID);
	if (RadioID == 26) Play_Random_Radio_Command(Team ? CtrlAlt_7_GDI : CtrlAlt_7_Nod, Team, PlayerID);
	if (RadioID == 27) Play_Random_Radio_Command(Team ? CtrlAlt_8_GDI : CtrlAlt_8_Nod, Team, PlayerID);
	if (RadioID == 28) Play_Random_Radio_Command(Team ? CtrlAlt_9_GDI : CtrlAlt_9_Nod, Team, PlayerID);
	if (RadioID == 29) Play_Random_Radio_Command(Team ? CtrlAlt_0_GDI : CtrlAlt_0_Nod, Team, PlayerID);
	return 0;
}

void KeyHookCall(void *Data2) {
	MDB_SSGM_KeyHook *Base = (MDB_SSGM_KeyHook *)Data2;
	Base->KeyHookFunc();
}

int MDB_SSGM_KeyHook::AddHook(const char *Key, GameObject *obj) {
	if (is_keyhook_set == 1337) {
		RemoveHook();
	}
	k = 0;
	k = new KeyHookStruct;
	k->data = this;
	k->hook = KeyHookCall;
	k->PlayerID = Get_Player_ID(obj);
	k->key = newstr(Key);
	hookid = AddKeyHook(k);
	return hookid;
}

void MDB_SSGM_KeyHook::RemoveHook() {
	if (hookid != 0 && RemoveKeyHook != 0) {
		RemoveKeyHook(hookid);
		hookid = 0;
		if (k != 0) {
			delete[] k->key;
			delete k;
			k = 0;
		}
	}
}

void MDB_SSGM_KeyHook::Detach(GameObject *obj) 
{
	if (is_keyhook_set == 1337) 
	{
		RemoveHook();
	}
}

void MDB_SSGM_KeyHook::Destroyed(GameObject *obj) 
{
	if (is_keyhook_set == 1337) 
	{
		RemoveHook();
	}
}

void Iran_Radio_Taunt_Key::Created(GameObject *obj) 
{
	if (is_keyhook_set != 1337) 
	{
		hookid = AddHook(Get_Parameter("Key"),obj);
		LastPress[Get_Player_ID(Owner())] = The_Game()->GameDuration_Seconds-5;
		is_keyhook_set = 1337;
	}
}

void Iran_Radio_Taunt_Key::KeyHookFunc() 
{
	const char* tmp = Get_Parameter("Key");
	Team = Get_Team(Get_Player_ID(Owner()));
	if (((int)The_Game()->GameDuration_Seconds - LastPress[Get_Player_ID(Owner())]) >= TauntPressWaitTime ) 
	{
		if (strcmp(tmp, "Taunt1") ==0)
			Play_Random_Radio_Command(Team ? Taunt1_GDI : Taunt1_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt2") ==0)
			Play_Random_Radio_Command(Team ? Taunt2_GDI : Taunt2_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt3") ==0)
			Play_Random_Radio_Command(Team ? Taunt3_GDI : Taunt3_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt4") ==0)
			Play_Random_Radio_Command(Team ? Taunt4_GDI : Taunt4_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt5") ==0)
			Play_Random_Radio_Command(Team ? Taunt5_GDI : Taunt5_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt6") ==0)
			Play_Random_Radio_Command(Team ? Taunt6_GDI : Taunt6_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt7") ==0)
			Play_Random_Radio_Command(Team ? Taunt7_GDI : Taunt7_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt8") ==0)
			Play_Random_Radio_Command(Team ? Taunt8_GDI : Taunt8_Nod, Team, Get_Player_ID(Owner()));
		else if (strcmp(tmp, "Taunt9") ==0)
			Play_Random_Radio_Command(Team ? Taunt9_GDI : Taunt9_Nod, Team, Get_Player_ID(Owner()));

		LastPress[Get_Player_ID(Owner())] = The_Game()->GameDuration_Seconds;
	}
}



void Plugin_Unload() {

}
 
extern "C" {
 
DLLEXPORT void SSGM_Chat_Hook(int ID, int Type, const wchar_t *Msg) {
}
}

void Load_Radio_Commands()
{
	Load_Radio_Command("Ctrl_1_GDI", Ctrl_1_GDI);
	Load_Radio_Command("Ctrl_1_Nod", Ctrl_1_Nod);
	Load_Radio_Command("Ctrl_2_GDI", Ctrl_2_GDI);
	Load_Radio_Command("Ctrl_2_Nod", Ctrl_2_Nod);
	Load_Radio_Command("Ctrl_3_GDI", Ctrl_3_GDI);
	Load_Radio_Command("Ctrl_3_Nod", Ctrl_3_Nod);
	Load_Radio_Command("Ctrl_4_GDI", Ctrl_4_GDI);
	Load_Radio_Command("Ctrl_4_Nod", Ctrl_4_Nod);
	Load_Radio_Command("Ctrl_5_GDI", Ctrl_5_GDI);
	Load_Radio_Command("Ctrl_5_Nod", Ctrl_5_Nod);
	Load_Radio_Command("Ctrl_6_GDI", Ctrl_6_GDI);
	Load_Radio_Command("Ctrl_6_Nod", Ctrl_6_Nod);
	Load_Radio_Command("Ctrl_7_GDI", Ctrl_7_GDI);
	Load_Radio_Command("Ctrl_7_Nod", Ctrl_7_Nod);
	Load_Radio_Command("Ctrl_8_GDI", Ctrl_8_GDI);
	Load_Radio_Command("Ctrl_8_Nod", Ctrl_8_Nod);
	Load_Radio_Command("Ctrl_9_GDI", Ctrl_9_GDI);
	Load_Radio_Command("Ctrl_9_Nod", Ctrl_9_Nod);
	Load_Radio_Command("Ctrl_0_GDI", Ctrl_0_GDI);
	Load_Radio_Command("Ctrl_0_Nod", Ctrl_0_Nod);

	Load_Radio_Command("Alt_1_GDI", Alt_1_GDI);
	Load_Radio_Command("Alt_1_Nod", Alt_1_Nod);
	Load_Radio_Command("Alt_2_GDI", Alt_2_GDI);
	Load_Radio_Command("Alt_2_Nod", Alt_2_Nod);
	Load_Radio_Command("Alt_3_GDI", Alt_3_GDI);
	Load_Radio_Command("Alt_3_Nod", Alt_3_Nod);
	Load_Radio_Command("Alt_4_GDI", Alt_4_GDI);
	Load_Radio_Command("Alt_4_Nod", Alt_4_Nod);
	Load_Radio_Command("Alt_5_GDI", Alt_5_GDI);
	Load_Radio_Command("Alt_5_Nod", Alt_5_Nod);
	Load_Radio_Command("Alt_6_GDI", Alt_6_GDI);
	Load_Radio_Command("Alt_6_Nod", Alt_6_Nod);
	Load_Radio_Command("Alt_7_GDI", Alt_7_GDI);
	Load_Radio_Command("Alt_7_Nod", Alt_7_Nod);
	Load_Radio_Command("Alt_8_GDI", Alt_8_GDI);
	Load_Radio_Command("Alt_8_Nod", Alt_8_Nod);
	Load_Radio_Command("Alt_9_GDI", Alt_9_GDI);
	Load_Radio_Command("Alt_9_Nod", Alt_9_Nod);
	Load_Radio_Command("Alt_0_GDI", Alt_0_GDI);
	Load_Radio_Command("Alt_0_Nod", Alt_0_Nod);

	Load_Radio_Command("CtrlAlt_1_GDI", CtrlAlt_1_GDI);
	Load_Radio_Command("CtrlAlt_1_Nod", CtrlAlt_1_Nod);
	Load_Radio_Command("CtrlAlt_2_GDI", CtrlAlt_2_GDI);
	Load_Radio_Command("CtrlAlt_2_Nod", CtrlAlt_2_Nod);
	Load_Radio_Command("CtrlAlt_3_GDI", CtrlAlt_3_GDI);
	Load_Radio_Command("CtrlAlt_3_Nod", CtrlAlt_3_Nod);
	Load_Radio_Command("CtrlAlt_4_GDI", CtrlAlt_4_GDI);
	Load_Radio_Command("CtrlAlt_4_Nod", CtrlAlt_4_Nod);
	Load_Radio_Command("CtrlAlt_5_GDI", CtrlAlt_5_GDI);
	Load_Radio_Command("CtrlAlt_5_Nod", CtrlAlt_5_Nod);
	Load_Radio_Command("CtrlAlt_6_GDI", CtrlAlt_6_GDI);
	Load_Radio_Command("CtrlAlt_6_Nod", CtrlAlt_6_Nod);
	Load_Radio_Command("CtrlAlt_7_GDI", CtrlAlt_7_GDI);
	Load_Radio_Command("CtrlAlt_7_Nod", CtrlAlt_7_Nod);
	Load_Radio_Command("CtrlAlt_8_GDI", CtrlAlt_8_GDI);
	Load_Radio_Command("CtrlAlt_8_Nod", CtrlAlt_8_Nod);
	Load_Radio_Command("CtrlAlt_9_GDI", CtrlAlt_9_GDI);
	Load_Radio_Command("CtrlAlt_9_Nod", CtrlAlt_9_Nod);
	Load_Radio_Command("CtrlAlt_0_GDI", CtrlAlt_0_GDI);
	Load_Radio_Command("CtrlAlt_0_Nod", CtrlAlt_0_Nod);

}

void Load_Taunt_Radio_Commands()
{
	Load_Radio_Command("Taunt1_GDI", Taunt1_GDI);
	Load_Radio_Command("Taunt2_GDI", Taunt2_GDI);
	Load_Radio_Command("Taunt3_GDI", Taunt3_GDI);
	Load_Radio_Command("Taunt4_GDI", Taunt4_GDI);
	Load_Radio_Command("Taunt5_GDI", Taunt5_GDI);
	Load_Radio_Command("Taunt6_GDI", Taunt6_GDI);
	Load_Radio_Command("Taunt7_GDI", Taunt7_GDI);
	Load_Radio_Command("Taunt8_GDI", Taunt8_GDI);
	Load_Radio_Command("Taunt9_GDI", Taunt9_GDI);

	Load_Radio_Command("Taunt1_Nod", Taunt1_Nod);
	Load_Radio_Command("Taunt2_Nod", Taunt2_Nod);
	Load_Radio_Command("Taunt3_Nod", Taunt3_Nod);
	Load_Radio_Command("Taunt4_Nod", Taunt4_Nod);
	Load_Radio_Command("Taunt5_Nod", Taunt5_Nod);
	Load_Radio_Command("Taunt6_Nod", Taunt6_Nod);
	Load_Radio_Command("Taunt7_Nod", Taunt7_Nod);
	Load_Radio_Command("Taunt8_Nod", Taunt8_Nod);
	Load_Radio_Command("Taunt9_Nod", Taunt9_Nod);
}